# BUGS

*The more you look, the more you see.*

Bugs in `sox-14.4.2` are first bulk-listed here as one-liners and then
migrate to the [issues](/sox_ng/sox_ng/issues).

## Already issued

- Fixes for all the CVEs reported against `sox-14.4.2`
- Patches from all the [Distros](Distros) that package SoX
- Tickets on [`sox.sf.net`:
  - [Patches](Fork-sox#patches)
  - [Merge requests](Fork-sox#merge-requests)
  - [Open bug reports](Fork-sox#open-bugs) created since 14.4.2
  - [Bug reports closed](Fork-sox#closed-bugs) since 14.4.2

## To be issued

[This OpenBSD post](https://www.mail-archive.com/ports%40openbsd.org/msg107748.html)

### Work in the forks

See [Forks](Forks).

### [Feature requests on `sox.sf.net`](https://sourceforge.net/p/sox/bugs/?limit=100)

| Feature | Issue |
| :------ | :---: |
| [236](https://sourceforge.net/p/sox/feature-requests/236) Citation form | #266 |
| [235](https://sourceforge.net/p/sox/feature-requests/235) Respect LD_LIBRARY_PATH for handler loading | #295 |
| [234](https://sourceforge.net/p/sox/feature-requests/234) Can Normalization Be Dom Independently For Each Channel | #512 |
| [233](https://sourceforge.net/p/sox/feature-requests/233) macos: curl not wget | #168 |
| [232](https://sourceforge.net/p/sox/feature-requests/232) Audio libraries | - |
| [231](https://sourceforge.net/p/sox/feature-requests/231) OptimFROG (ofr) Support | #192 |
| [230](https://sourceforge.net/p/sox/feature-requests/230) Support overlapping fade effect | #513 |
| [229](https://sourceforge.net/p/sox/feature-requests/229) Monkeys Audio (APE) Support | #193 |
| [228](https://sourceforge.net/p/sox/feature-requests/228) Remix: Arbitrary select channels from each input file | #514 |
| [227](https://sourceforge.net/p/sox/feature-requests/227) The length of output data is not reported for sox_open_mem_write() | #515 |
| [226](https://sourceforge.net/p/sox/feature-requests/226) Seekable support in sox_open_memstream_write() and sox_open_mem_write() | #516 |
| [225](https://sourceforge.net/p/sox/feature-requests/225) Spectrogram - Log/MEL/Bark frequency scaling options | Log: #165<BR>MEL/Bark: #267 |
| [224](https://sourceforge.net/p/sox/feature-requests/224) Support arbitrary bits number. (ie: -b 20 ) | #690 |
| [223](https://sourceforge.net/p/sox/feature-requests/223) Get in-file loop information | #700 |
| [221](https://sourceforge.net/p/sox/feature-requests/221) Implement DSF support | #44 |
| [220](https://sourceforge.net/p/sox/feature-requests/220) GUI Frontend | - |
| [219](https://sourceforge.net/p/sox/feature-requests/219) SAPI event data (EVNT chunk) |  |
| [216](https://sourceforge.net/p/sox/feature-requests/216) Equalizer and Convolution (FIR) of stereo files. | #706 |
| [215](https://sourceforge.net/p/sox/feature-requests/215) rate with multiply/divide of sampling rate | #701 |
| [214](https://sourceforge.net/p/sox/feature-requests/214) Comment in spectrogram not supporting non-ASCII | #707 |
| [213](https://sourceforge.net/p/sox/feature-requests/213) Add mp3 support by default as it became patent free on 16 April 2017 | Done |
| [212](https://sourceforge.net/p/sox/feature-requests/212) Convolver | #702 |
| [211](https://sourceforge.net/p/sox/feature-requests/211) use passband and move in frequency |  |
| [210](https://sourceforge.net/p/sox/feature-requests/210) Add .xtr audio file format | |
| [208](https://sourceforge.net/p/sox/feature-requests/208) export phase info as png via spectrogram |  |
| [207](https://sourceforge.net/p/sox/feature-requests/207) spectogram to svg | - |
| [206](https://sourceforge.net/p/sox/feature-requests/206) Add codec2 for low bitrate voice as a replacement for LPC-10. | #705 |
| [205](https://sourceforge.net/p/sox/feature-requests/205) Feature request - default audio device | #521 |
| [204](https://sourceforge.net/p/sox/feature-requests/204) sox.html | - |
| [203](https://sourceforge.net/p/sox/feature-requests/203) Support for M4A? | #198 |
| [202](https://sourceforge.net/p/sox/feature-requests/202) Support "pcm" format of the game "Dracula X" (sega saturn) | - |
| [201](https://sourceforge.net/p/sox/feature-requests/201) Add sound meter features | - |
| [200](https://sourceforge.net/p/sox/feature-requests/200) adp format request for conversion | #523 |
| [199](https://sourceforge.net/p/sox/feature-requests/199) simpler standalone binary please | - |
| [198](https://sourceforge.net/p/sox/feature-requests/198) fixed normalization | - |
| [197](https://sourceforge.net/p/sox/feature-requests/197) SetRecordingDurationBySox | - |
| [196](https://sourceforge.net/p/sox/feature-requests/196) fade based on previous and next file in concatenation of audio files | - |
| [195](https://sourceforge.net/p/sox/feature-requests/195) Display audio properties and spectrogram settings in spectrograms | #703 |
| [194](https://sourceforge.net/p/sox/feature-requests/194) Enable AMR-WB encoding support in SoX | #704 |
| [193](https://sourceforge.net/p/sox/feature-requests/193) Spectrum of Frequencies into dat file | #708 |
| [192](https://sourceforge.net/p/sox/feature-requests/192) Opus File Encoding Support | #709 |
| [190](https://sourceforge.net/p/sox/feature-requests/190) Save spectrograms as text file | #708 |
| [189](https://sourceforge.net/p/sox/feature-requests/189) Reading Support (or more) for DTS-HD |  |
| [188](https://sourceforge.net/p/sox/feature-requests/188) new release with opus file reading support? | - |
| [187](https://sourceforge.net/p/sox/feature-requests/187) Square (U parabola) fade | #710 |
| [183](https://sourceforge.net/p/sox/feature-requests/183) soxi to JSON | #711 |
| [181](https://sourceforge.net/p/sox/feature-requests/181) Can't read Large Wave files (No Header) | - |
| [180](https://sourceforge.net/p/sox/feature-requests/180) Higher Precision with Speed. | - |
| [179](https://sourceforge.net/p/sox/feature-requests/179) append to tags | - |
| [178](https://sourceforge.net/p/sox/feature-requests/178) Waveform Display for SoX | #713 |
| [177](https://sourceforge.net/p/sox/feature-requests/177) WavPack ReplayGain support |  |
| [176](https://sourceforge.net/p/sox/feature-requests/176) Log Frequency Scale for Spectrogram | #165 |
| [175](https://sourceforge.net/p/sox/feature-requests/175) Use pkg-config for all library detection |  |
| [174](https://sourceforge.net/p/sox/feature-requests/174) Sidechain functionality for compand/mcompand effects | #715 |
| [173](https://sourceforge.net/p/sox/feature-requests/173) dsd to pcm support | #44 |
| [172](https://sourceforge.net/p/sox/feature-requests/172) logarithmic fade only spans across half the fade-out-length | - |
| [170](https://sourceforge.net/p/sox/feature-requests/170) alpha channel for spectrograms | #716 |
| [168](https://sourceforge.net/p/sox/feature-requests/168) wish: raw, realtime spectrogram data (graphical equaliser) | #708 |
| [167](https://sourceforge.net/p/sox/feature-requests/167) Statistics: EBU R128 specifications | #151 |
| [166](https://sourceforge.net/p/sox/feature-requests/166) SoX for WinCE | #522 |
| [165](https://sourceforge.net/p/sox/feature-requests/165) Better directory support | #718 |
| [164](https://sourceforge.net/p/sox/feature-requests/164) play: interactive selection of output channels | #719 |
| [163](https://sourceforge.net/p/sox/feature-requests/163) Apply effects to specific channels only | #716 |
| [162](https://sourceforge.net/p/sox/feature-requests/162) Plot combined response of cascaded filters |  |
| [161](https://sourceforge.net/p/sox/feature-requests/161) time stretch with DIRAC alg. |  |
| [156](https://sourceforge.net/p/sox/feature-requests/156) v4.13 Fake temporary files in Windows |  |
| [154](https://sourceforge.net/p/sox/feature-requests/154) ima-adpcm in RAW |  |
| [153](https://sourceforge.net/p/sox/feature-requests/153) New feature: using a profile for highpass/​lowpass filter |  |
| [150](https://sourceforge.net/p/sox/feature-requests/150) Tape wow and flutter correction |  |
| [149](https://sourceforge.net/p/sox/feature-requests/149) Request for Project Wiki | - |
| [147](https://sourceforge.net/p/sox/feature-requests/147) Deliver libsox.dll for win32 |  |
| [146](https://sourceforge.net/p/sox/feature-requests/146) Will G.723 (111) be added for wav files? |  |
| [145](https://sourceforge.net/p/sox/feature-requests/145) Request for different tunings in synth | #729 |
| [144](https://sourceforge.net/p/sox/feature-requests/144) Mac OS X binaries info |  |
| [141](https://sourceforge.net/p/sox/feature-requests/141) Stereo center removal (not oops) | #730 |
| [135](https://sourceforge.net/p/sox/feature-requests/135) CAF with IMA4 support |  |
| [134](https://sourceforge.net/p/sox/feature-requests/134) Monkey's Audio decoding support | #193 |
| [129](https://sourceforge.net/p/sox/feature-requests/129) Add sox_add_effect_with_auto() utility |  |
| [128](https://sourceforge.net/p/sox/feature-requests/128) Do not export lsx_ symbols in libsox |  |
| [127](https://sourceforge.net/p/sox/feature-requests/127) Allow inputs to have different rates while concat'ing |  |
| [125](https://sourceforge.net/p/sox/feature-requests/125) Split existing speech file on silence |  |
| [124](https://sourceforge.net/p/sox/feature-requests/124) Fade out should allow stop-time="end of the file" with pipes |  |
| [123](https://sourceforge.net/p/sox/feature-requests/123) Support DDWAV files |  |
| [122](https://sourceforge.net/p/sox/feature-requests/122) Error handling .ACT wav files | #735 |
| [121](https://sourceforge.net/p/sox/feature-requests/121) soxrc |  |
| [119](https://sourceforge.net/p/sox/feature-requests/119) RMS Normlization |  |
| [117](https://sourceforge.net/p/sox/feature-requests/117) Format lists in --help text |  |
| [113](https://sourceforge.net/p/sox/feature-requests/113) dynamic SoX Effects |  |
| [109](https://sourceforge.net/p/sox/feature-requests/109) sox as vst plugin |  |
| [108](https://sourceforge.net/p/sox/feature-requests/108) OSS plugin should support 24 and 32 bit formats |  |
| [103](https://sourceforge.net/p/sox/feature-requests/103) Support .mpc |  |
| [102](https://sourceforge.net/p/sox/feature-requests/102) Support for .act |  |
| [101](https://sourceforge.net/p/sox/feature-requests/101) Support .ape |  |
| [99](https://sourceforge.net/p/sox/feature-requests/99) Replace or supplement use of wget with (lib)curl | (#112) #168 |
| [96](https://sourceforge.net/p/sox/feature-requests/96) Push file detection into libmagic and use that |  |
| [95](https://sourceforge.net/p/sox/feature-requests/95) Separate formats and CODECs |  |

### The [182 commits on `sox.sf.net`](https://sourceforge.net/p/sox/code/commit_browser) since 14.4.2

Some of its commits have been applied: those which became Debian patches
and others necessary for other patches to apply including:

| `sox.sf.net`<BR>commit | Description | Issue/<BR>commit |
| [9ce4a4a](https://sourceforge.net/p/sox/code/ci/9ce4a4a) | Segmentation fault in rate.c:504:30 [bug 334](https://sourceforge.net/p/sox/bugs/334) | #56 |
| [ccedd08](https://sourceforge.net/p/sox/code/ci/ccedd08) | Clean up lsx_malloc() and friends | #57 |
| [3518bcd](https://sourceforge.net/p/sox/code/ci/3518bcd) | Define sox_intN_t types using standard intN_t | #249 |

These are from [h3nd24-sox](https://git.code.sf.net/u/h3nd24/sox):

| `sox.sf.net`<BR>commit | Description | Issue/<BR>commit |
| :-: | :- | :-: |
| 2f6b3fec | riaa: add support for 192k sample rate |  |
| 5761edbc | win32-glob: fix resource leak on bad pattern |  |
| 2ce02fea | fix possible null pointer deref in lsx_make_lpf() (CVE-2019-8357) |  |
| b7883ae1 | fft4g: bail if size too large (CVE-2019-8356) |  |
| f8587e2d | fix possible overflow in lsx_(re)valloc() size calculation (CVE-2019-8355) |  |
| f7091126 | fix possible buffer size overflow in lsx_make_lpf() (CVE-2019-8354) |  |
| ccedd088 | Clean up lsx_malloc() and friends | #57 |  |
| 03b4667b | sox: use sigaction where available [bug #214] |  |
| ec073861 | make: update exported symbol list [bug #266] |  |
| 491c2bb2 | hcom: report input file length |  |
| 35fa4b6c | hcom: fix writing absurdly large files |  |
| 5735eaec | hcom: limit input size to 2G samples |  |
| 18d2609a | hcom: fix pointer type confusion [bug #308] |  |
| 998208fd | hcom: fix double free on writing zero-length file |  |
| 1968a7f0 | wav: check for block align overflow [bug #279] |  |
| 6b6a2930 | wav: disallow zero-size chunks [bug #278] |  |
| 8c2be5c7 | wav: adpcm: stricter header validation [bug #265] |  |
| 37e998b0 | voc: abort if channel count or sample format changes [bug #265] |  |
| e81229cd | aiff: fix handling of unknown odd-sized chunks [bug #286] |  |
| 9b27bc7f | amr: check for invalid block types [bug #305] |  |
| 9c12c40e | oss: prefer stereo mode [bug #300] |  |
| 342d3e71 | oss: fix input buffer overrun [bug #300] |  |
| 9923bcf0 | msvc: fix build with Visual Studio 2015 [bug #282] |  |
| 4b547a07 | doc: fix doubled pdf output [bug #261] |  |
| 7bfb3d8c | doc: fix out of tree text/pdf/html generation |  |
| 228a5709 | doc: fix obsolete example in INSTALL file [bug #257] |  |
| db1c5a45 | spelling fixes |  |
| 000b31b9 | update FSF mailing address [bug #301] |  |
| 8dcd32b1 | delete debian packaging files [bug #270] |  |
| 0d70a21c | make: add $(DESTDIR) in installcheck target [bug #302] |  |
| 09d7388c | xa: validate channel count (CVE-2017-18189) |  |
| f56c0dbc | aiff: fix crash on empty comment chunk (CVE-2017-15642) |  |
| 515b9861 | adpcm: fix stack overflow with >4 channels (CVE-2017-15372) |  |
| 968c689a | flac: fix crash on corrupt metadata (CVE-2017-15371) |  |
| e076a7ad | wav: ima_adpcm: fix buffer overflow on corrupt input (CVE-2017-15370) |  |
| 7b3f30e1 | wav: fix crash writing header when channel count >64k (CVE-2017-11359) |  |
| e410d00c | hcom: fix crash on input with corrupt dictionary (CVE-2017-11358) |  |
| 6e177c45 | wav: fix crash if channel count is zero (CVE-2017-11332) |  |
| 7e74b254 | Remove hepler script. It's mostly unmaintained, I don't know if anyone but me ever used it. In any case, those who want a custom Debian package should be capable of updating the debian/changelog entry on their own. |  |
| 19bdf7ef | chmod'ing unneeded executable bit. |  |
| e9189be4 | Merge most Debian changes into master. |  |
| cfc3ccc2 | Read for more development. |  |
| d41836d3 | Fixes for issues found during 14.4.2 release. |  |
| 45b161d7 | sox-14.4.2 release |  |

## To be added

* [Cannot play/record under Windows](https://public-inbox.org/sox-users/57c1e579.46d0620a.54ca2.c765@mx.google.com/t/) fails in 14.4.2, works in 14.4.1
* [Debian bug tracker](https://bugs.debian.org/cgi-bin/pkgreport.cgi?package=sox)
* [Ubuntu bug tracker](https://launchpad.net/ubuntu/+source/sox/+bugs)
