# Boost.Iterator

Boost.Iterator, part of collection of the [Boost C++ Libraries](https://github.com/boostorg), provides tools for building and working with iterators in C++. The library also provides a number of iterator classes that can be used out of the box.

### Directories

* **doc** - Documentation sources
* **include** - Interface headers of Boost.Iterator
* **test** - Boost.Iterator unit tests
* **example** - Boost.Iterator usage examples

### More information

* [Documentation](https://boost.org/libs/iterator)
* [Report bugs](https://github.com/boostorg/iterator/issues/new). Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as [pull requests](https://github.com/boostorg/iterator/compare) against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).

### Build status

Branch          | GitHub Actions | AppVeyor | Test Matrix | Dependencies |
:-------------: | -------------- | -------- | ----------- | ------------ |
[`master`](https://github.com/boostorg/iterator/tree/master) | [![GitHub Actions](https://github.com/boostorg/iterator/actions/workflows/ci.yml/badge.svg?branch=master)](https://github.com/boostorg/iterator/actions?query=branch%3Amaster) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/ud8ug5aai8vd30hg/branch/master?svg=true)](https://ci.appveyor.com/project/Lastique/iterator/branch/master) | [![Tests](https://img.shields.io/badge/matrix-master-brightgreen.svg)](https://regression.boost.io/master/developer/iterator.html) | [![Dependencies](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/iterator.html)
[`develop`](https://github.com/boostorg/iterator/tree/develop) | [![GitHub Actions](https://github.com/boostorg/iterator/actions/workflows/ci.yml/badge.svg?branch=develop)](https://github.com/boostorg/iterator/actions?query=branch%3Adevelop) | [![AppVeyor](https://ci.appveyor.com/api/projects/status/ud8ug5aai8vd30hg/branch/develop?svg=true)](https://ci.appveyor.com/project/Lastique/iterator/branch/develop) | [![Tests](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](https://regression.boost.io/develop/developer/iterator.html) | [![Dependencies](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/iterator.html)

### License

Distributed under the [Boost Software License, Version 1.0](https://www.boost.org/LICENSE_1_0.txt).
