// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sve -target-feature +sve-bitperm -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +ssve-bitperm -target-feature +sve -verify=streaming-guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +ssve-bitperm -target-feature +sve -target-feature +sve-bitperm -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,sve-bitperm" streaming_guard="sme,ssve-bitperm" flags="feature-dependent"

void test(void) {
  svuint8_t svuint8_t_val;
  svuint16_t svuint16_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;
  uint8_t uint8_t_val;
  uint16_t uint16_t_val;
  uint32_t uint32_t_val;
  uint64_t uint64_t_val;

  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint8_t_val, uint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint16_t_val, svuint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint16_t_val, uint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint32_t_val, svuint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint32_t_val, uint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint64_t_val, svuint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_n_u8(svuint8_t_val, uint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_n_u16(svuint16_t_val, uint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_n_u32(svuint32_t_val, uint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_n_u64(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_u8(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_u16(svuint16_t_val, svuint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_u32(svuint32_t_val, svuint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_u64(svuint64_t_val, svuint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint8_t_val, uint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint16_t_val, svuint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint16_t_val, uint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint32_t_val, svuint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint32_t_val, uint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint64_t_val, svuint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_n_u8(svuint8_t_val, uint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_n_u16(svuint16_t_val, uint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_n_u32(svuint32_t_val, uint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_n_u64(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_u8(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_u16(svuint16_t_val, svuint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_u32(svuint32_t_val, svuint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_u64(svuint64_t_val, svuint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint8_t_val, uint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint16_t_val, svuint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint16_t_val, uint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint32_t_val, svuint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint32_t_val, uint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint64_t_val, svuint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_n_u8(svuint8_t_val, uint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_n_u16(svuint16_t_val, uint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_n_u32(svuint32_t_val, uint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_n_u64(svuint64_t_val, uint64_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_u8(svuint8_t_val, svuint8_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_u16(svuint16_t_val, svuint16_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_u32(svuint32_t_val, svuint32_t_val);
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_u64(svuint64_t_val, svuint64_t_val);
}

void test_streaming(void) __arm_streaming{
  svuint8_t svuint8_t_val;
  svuint16_t svuint16_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;
  uint8_t uint8_t_val;
  uint16_t uint16_t_val;
  uint32_t uint32_t_val;
  uint64_t uint64_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep(svuint8_t_val, uint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep(svuint16_t_val, svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep(svuint16_t_val, uint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep(svuint32_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep(svuint32_t_val, uint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep_n_u8(svuint8_t_val, uint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep_n_u16(svuint16_t_val, uint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep_n_u32(svuint32_t_val, uint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep_u16(svuint16_t_val, svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep_u32(svuint32_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbdep_u64(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext(svuint8_t_val, uint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext(svuint16_t_val, svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext(svuint16_t_val, uint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext(svuint32_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext(svuint32_t_val, uint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext_n_u8(svuint8_t_val, uint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext_n_u16(svuint16_t_val, uint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext_n_u32(svuint32_t_val, uint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext_u16(svuint16_t_val, svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext_u32(svuint32_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbext_u64(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp(svuint8_t_val, uint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp(svuint16_t_val, svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp(svuint16_t_val, uint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp(svuint32_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp(svuint32_t_val, uint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp_n_u8(svuint8_t_val, uint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp_n_u16(svuint16_t_val, uint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp_n_u32(svuint32_t_val, uint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp_u16(svuint16_t_val, svuint16_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp_u32(svuint32_t_val, svuint32_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svbgrp_u64(svuint64_t_val, svuint64_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svuint8_t svuint8_t_val;
  svuint16_t svuint16_t_val;
  svuint32_t svuint32_t_val;
  svuint64_t svuint64_t_val;
  uint8_t uint8_t_val;
  uint16_t uint16_t_val;
  uint32_t uint32_t_val;
  uint64_t uint64_t_val;

  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint8_t_val, uint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint16_t_val, svuint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint16_t_val, uint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint32_t_val, svuint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint32_t_val, uint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint64_t_val, svuint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_n_u8(svuint8_t_val, uint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_n_u16(svuint16_t_val, uint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_n_u32(svuint32_t_val, uint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_u16(svuint16_t_val, svuint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_u32(svuint32_t_val, svuint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbdep_u64(svuint64_t_val, svuint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint8_t_val, uint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint16_t_val, svuint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint16_t_val, uint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint32_t_val, svuint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint32_t_val, uint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint64_t_val, svuint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_n_u8(svuint8_t_val, uint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_n_u16(svuint16_t_val, uint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_n_u32(svuint32_t_val, uint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_u16(svuint16_t_val, svuint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_u32(svuint32_t_val, svuint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbext_u64(svuint64_t_val, svuint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint8_t_val, uint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint16_t_val, svuint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint16_t_val, uint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint32_t_val, svuint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint32_t_val, uint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint64_t_val, svuint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_n_u8(svuint8_t_val, uint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_n_u16(svuint16_t_val, uint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_n_u32(svuint32_t_val, uint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_n_u64(svuint64_t_val, uint64_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_u8(svuint8_t_val, svuint8_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_u16(svuint16_t_val, svuint16_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_u32(svuint32_t_val, svuint32_t_val);
  // guard-error@+2 {{builtin can only be called from a non-streaming function}}
  // streaming-guard-error@+1 {{builtin can only be called from a streaming function}}
  svbgrp_u64(svuint64_t_val, svuint64_t_val);
}
